-- DGD Global Debug Functions
function PrintTable(currTable)

  rStr = ""
  hStr = ""
 
  for key,value in pairs(currTable) do

    sLen, tStr = EntryToString(value)

  
    headStr = "| " .. key .. " "

    -- TODO: FIX ME!
    if string.len(headStr) <= sLen then
      headStr = pad(headStr, sLen)
    else
      tStr = pad(tStr, string.len(headStr))
    end

    rStr = rStr .. tStr
    hStr = hStr .. headStr

  end  

  rStr = rStr .. "|"
  hStr = hStr .. "|"

  bStr = ""
  bStr = pad(bStr, string.len(hStr), "*")

  DebugOut(hStr)
  DebugOut(bStr)
  DebugOut(rStr)

  --return sLen, rStr
end

function EntryToString(value)

  rVal = ""

  if type(value) == "table" then

    -- TODO: FIX ME!!!
    --sLen, rVal = TableToString(value)
    rVal = "| TABLE (".. table.getn(value)..") "

    sLen = string.len(rVal)

  elseif type(value) == "nil" then
    rVal = "| !!NIL!! "
    sLen = string.len(rVal)

  elseif type(value) == "function" then
    rVal = "| !!FUNC!! "
    sLen = string.len(rVal)

  elseif type(value) == "number" then
    rVal = "| "..value.." "
    sLen = string.len(rVal)

  elseif type(value) == "string" then
    rVal = "| "..value.." "
    sLen = string.len(rVal)

  else
    --DebugOut("Value Type: " .. type(value) .. "\n")
    rVal = "| ??? "
    sLen = string.len(rVal)
  end

  return sLen, rVal

end

--[[
function PrintTable(currTable)

  sLen, pStr = TableToString(currTable)

  DebugOut(pStr)

end
]]--

function pad(s, width, padder)
  padder = string.rep(padder or " ", width) --math.abs(width))
  if width < 0 then return string.sub(padder .. s, width) end
  return string.sub(s .. padder, 1, width)
end

function PrintTabTable(title, currTable, depth) 
   
  if type(currTable) ~= "table" then 
    if(depth ~= nil) then 
      DebugOut("Invalid Variable Type for PrintTable call: "..type(currTable)) 
    else 
      DebugOut("!INVALID!") 
    end 
  else 
    local currDepth = depth or 0 
 
    DebugOut( pad("", currDepth*2) .. title .. "={") 
    -- adds depth each time 
    for key, value in pairs(currTable) do 
      PrintTabElem(key, value, currDepth+1) 
    end 
    DebugOut( pad("", currDepth*2) .. "}") 
  end 
end
 
function PrintTabElem(key, value, depth) 
  if type(value) == "table" then 
    PrintTabTable(key, value, depth+1) 
  elseif type(value) == "function" then 
    DebugOut( pad("", depth*2) .. "(function) " .. key) 
  elseif type(value) == "nil" then 
    DebugOut( pad("", depth*2) .. "(nil) " .. key) 
  else 
    DebugOut( pad("", depth*2) .. key .. ":" .. value) 
  end 
end